//import java.awt.Graphics;

public class cell{ // extends java.awt.Canvas{

public short x;
public short y;
public byte state;
public byte newState;
public int posType;  // 0 3 3 3 3 6   describes absolute field position (neighbours) acc. to picture on the left
                                     // 1 4 4 4 4 7
                                     // 1 4 4 4 4 7
                                     // 1 4 4 4 4 7
                                     // 1 4 4 4 4 7
                                     // 2 5 5 5 5 8
public static final byte maxstate=3; 
     //0: empty
     //1: fish
     //2: shark
     //(99:movement)
public static timer globaltime;
public static universe earth;
//neighbours:
public cell up=null;
public cell down=null;
public cell left=null;
public cell right=null;
public cell temp;
//counters:
public byte pregnancy;
public byte starving;

// sets / resets the cells values, counters 
public void initVals(){
pregnancy=0;
starving=0;
}

public void updateBorder(int borderStyle){
if(borderStyle==0){
  switch(posType){
    case 0: setup(down.get2()); setleft(right.get6()); right.updateBorder(borderStyle); down.updateBorder(borderStyle); break;
    case 3: setup(left.up.right); right.updateBorder(borderStyle); break;
    case 6: setup(left.up.right); break;
    case 1: setleft(up.left.down); down.updateBorder(borderStyle); break;
    case 2: setleft(up.left.down); break; 
    }
  }else{
if(borderStyle==2){
  switch(posType){
    case 0: up=this; left=this; break;
    case 2: down=this; left=this; break;
    case 6: up=this; right=this; break;
    case 8: down=this; right=this; break;
    case 1: left=this; break;
    case 3: up=this; break;
    case 7: right=this; break;
    case 5: down=this;
    }}
if(borderStyle==1){
  switch(posType){
    case 0: up=null; left=null; break;
    case 2: down=null; left=null; break;
    case 6: up=null; right=null; break;
    case 8: down=null; right=null; break;
    case 1: left=null; break;
    case 3: up=null; break;
    case 7: right=null; break;
    case 5: down=null;
    }}
switch(posType){
  case 0: right.updateBorder(borderStyle); down.updateBorder(borderStyle); break;
  case 3:
  case 2:
  case 5: right.updateBorder(borderStyle); break;
  case 1:
  case 7:
  case 6: down.updateBorder(borderStyle);
  }
}
}

public cell get2(){
  if(posType==1)
    return down.get2();
  if(posType==2)
   return this;
return null;
}

public cell get6(){
  if(posType==3)
    return right.get6();
  if(posType==6)
   return this;
return null;
}

public cell getRandomNeighbour(byte whom){
//looks like Spaghetti code...

//count empty neighbours
int temp=0;
 if((left!=null)&&(left.state==whom || (left.state==99 && left.newState==whom))) temp++;
 if((right!=null)&&(right.state==whom || (right.state==99 && right.newState==whom))) temp++;
 if((up!=null)&&(up.state==whom || (up.state==99 && up.newState==whom))) temp++;
 if((down!=null)&&(down.state==whom || (down.state==99 && down.newState==whom))) temp++;
 if((left!=null)&&(left.up!=null)&&(left.up.state==whom || (left.up.state==99 && left.up.newState==whom))) temp++;
 if((left!=null)&&(left.down!=null)&&(left.down.state==whom || (left.down.state==99 && left.down.newState==whom))) temp++; 
 if((right!=null)&&(right.up!=null)&&(right.up.state==whom || (right.up.state==99 && right.up.newState==whom))) temp++; 
 if((right!=null)&&(right.down!=null)&&(right.down.state==whom || (right.down.state==99 && right.down.newState==whom))) temp++; 

if(temp==0) return null;  //no matches found
temp=earth.fate.nextInt(++temp);

//count down again and return last
 if((left!=null)&&(left.state==whom || (left.state==99 && left.newState==whom))) {temp--; if(temp<=0) return left;}
 if((right!=null)&&(right.state==whom || (right.state==99 && right.newState==whom))) {temp--; if(temp<=0) return right;}
 if((up!=null)&&(up.state==whom || (up.state==99 && up.newState==whom))) {temp--; if(temp<=0) return up;}
 if((down!=null)&&(down.state==whom || (down.state==99 && down.newState==whom))) {temp--;  if(temp<=0) return down;}
 if((left!=null)&&(left.up!=null)&&(left.up.state==whom || (left.up.state==99 && left.up.newState==whom))) {temp--; if(temp<=0) return left.up;}
 if((left!=null)&&(left.down!=null)&&(left.down.state==whom || (left.down.state==99 && left.down.newState==whom))) {temp--; if(temp<=0) return left.down;}
 if((right!=null)&&(right.up!=null)&&(right.up.state==whom || (right.up.state==99 && right.up.newState==whom))) {temp--; if(temp<=0) return right.up;}
 if((right!=null)&&(right.down!=null)&&(right.down.state==whom || (right.down.state==99 && right.down.newState==whom))) {temp--; if(temp<=0) return right.down;}
return null;
}

public void update(){
if(globaltime.even){
if(state!=newState){
  state=newState;      //repaint modus

//this line is for fast, no animation update
//earth.grid[x][y]=state;

//with this line graphic repaint is faster, since just changed cells are 
//called, but then no animation is possible :-(
//  earth.repaint(1000,x*earth.cellW,y*earth.cellH,earth.cellW,earth.cellH);
  }

//update states every cycle
if(state==0)
  earth.grid[x][y]=0;
 else
 {
 if(earth.timecourse){//makes age / hunger of objecst visible
  if(state==1)
    earth.grid[x][y]=(byte)(19-((pregnancy*9) / earth.fp));
  if(state==2)
    earth.grid[x][y]=(byte)(20+((starving*9) / earth.ss));
  }
 else
  {//no time course but fancy animation stuff
  if(state==1){
    if(earth.fate.nextBoolean())
      earth.grid[x][y]=1;
    else
      earth.grid[x][y]=3;
    }
  if(state==2){
    if(starving!=0)
      earth.grid[x][y]=2;
    else
      earth.grid[x][y]=4;
    }
  }       
 }
//repaint every cycle, slower than commented line above:
earth.repaint(100,x*earth.cellW,y*earth.cellH,earth.cellW,earth.cellH);
  }else       //apply cell rule
  {
  if(state==1)//fish
    {//move first
    temp=getRandomNeighbour((byte)0);
    if(temp!=null){
      state=99;
      temp.state=99;
      temp.newState=1;
      if(pregnancy>=earth.fp)
        {
        temp.pregnancy=0;
        earth.numFishes++;
        initVals();
        newState=1;
        }
      else
        {
        if(pregnancy<earth.fp)
          temp.pregnancy=++pregnancy;
        newState=0;
        }
      }
    if(state!=99 && pregnancy<earth.fp){
      pregnancy++;
      }
    }else //end fish
  if(state==2)//shark
    {//die of hunger?
    if(starving>=earth.ss)
      {
      state=99;
      newState=0;
      earth.numSharks--;
      }else //eat fish?
       if((temp=getRandomNeighbour((byte)1))!=null)
       {
       temp.starving=0;
       earth.numFishes--;
       temp.state=99;
       temp.newState=2;
       state=99;
       if(pregnancy>=earth.sp)
         {
         newState=2;
         temp.pregnancy=0;
         earth.numSharks++;
         initVals();
         }
       else
         {
         temp.pregnancy=++pregnancy;
         newState=0;
         }
       }else //no fish, move random
        {
        temp=getRandomNeighbour((byte)0);
        if(temp!=null){
          state=99;
          temp.state=99;
          temp.newState=2;
          temp.starving=++starving;
          if(pregnancy>=earth.sp)
            {
            newState=2;
            temp.pregnancy=0;
            earth.numSharks++;
            initVals();
            }
          else
            {
            temp.pregnancy=++pregnancy;
            newState=0;
            }
          }
        }
    if(state!=99){
      pregnancy++;
      starving++;
      }
    }     //end shark
  }
             //now tell your neighbour:
switch(posType){                                                 // 0 3 3 3 3 6   describes absolute field position (neighbours) acc. to picture on the left
  case 0: right.update(); down.update(); break;// 1 4 4 4 4 7
  case 1: right.update(); down.update(); break;// 1 4 4 4 4 7
  case 6: break;                                                       // 1 4 4 4 4 7
  case 7: break;                                                       // 1 4 4 4 4 7
  case 8: break;                                                       // 2 5 5 5 5 8
  default: right.update();
  }
}

public void xy(short x, short y){
this.x=x;
this.y=y;
//System.out.println(x+"*"+y);
//System.out.println(state);
//System.out.println(earth);
earth.grid[x][y]=state;
             //now tell your neighbour:
switch(posType){                                                 // 0 3 3 3 3 6   describes absolute field position (neighbours) acc. to picture on the left
  case 0: right.xy(++x,y); down.xy((short)0,++y); break;// 1 4 4 4 4 7
  case 1: right.xy(++x,y); down.xy((short)0,++y); break;// 1 4 4 4 4 7
  case 6: break;                                                       // 1 4 4 4 4 7
  case 7: break;                                                       // 1 4 4 4 4 7
  case 8: break;                                                       // 2 5 5 5 5 8
  default: right.xy(++x,y);
  }
}

public void get(int x, int y){
if(this.x==x && this.y==y)
  earth.search=this;
             //else tell your neighbour:
switch(posType){                                                 // 0 3 3 3 3 6   describes absolute field position (neighbours) acc. to picture on the left
  case 0: right.get(x,y); down.get(x,y); break;// 1 4 4 4 4 7
  case 1: right.get(x,y); down.get(x,y); break;// 1 4 4 4 4 7
  case 6: break;                                                       // 1 4 4 4 4 7
  case 7: break;                                                       // 1 4 4 4 4 7
  case 8: break;                                                       // 2 5 5 5 5 8
  default: right.get(x,y);
  }
}

public void inc(universe holder){      //increase grid by one cell on every side (size=size+2)
if(posType==0){
  cell x; cell y; cell z;
  posType=4; x=new cell(1); setleft(x);y=new cell(3); setup(y); z=new cell(0); x.setup(z); y.setleft(z); holder.upperleft=z; right.inc(); down.inc();
  }
}

public void inc(){
cell x; cell y; cell z;
switch(posType){                                                 
  case 3: posType=4; x=new cell(3); setup(x); x.setleft(left.up); right.inc(); break;
  case 6: posType=4; x=new cell(3); setup(x); x.setleft(left.up); y=new cell(7); y.setleft(this); z=new cell(6); z.setleft(x); y.setup(z); down.inc(); break;
  case 7: posType=4; x=new cell(7); x.setleft(this); x.setup(up.right); down.inc(); break;
  case 8: posType=9; x=new cell(5); x.setup(this); y=new cell(7); y.setleft(this); y.setup(up.right); z=new cell(8); z.setleft(x); z.setup(y); break;
  case 1: posType=4; x=new cell(1); setleft(x); x.setup(up.left); down.inc(); break;
  case 2: posType=4; x=new cell(1); setleft(x); x.setup(up.left); y=new cell(5); y.setup(this); z=new cell(2); z.setup(x); y.setleft(z); right.inc(); break;
  case 5: posType=4; x=new cell(5); x.setup(this); x.setleft(left.down); right.inc(); break;
  case 9: posType=4; down.setleft(left.down); //lower right edge, formerly 8
  }
}

public static int[] pop(int[] source){
int[] dest=new int[source.length-1];
System.arraycopy(source,1,dest,0,source.length-1);
return dest;
}

public static int[][] pop(int[][] source){
int[][] dest=new int[source.length-1][source[0].length];
for(int x=0;x<source.length-1;x++)
  dest[x]=source[x+1];
return dest;
}

public void paste(int[][] pict){
paste(pict[0]);                               //get your line
if(pict.length>1 &&down!=null)//and send rest down
  down.paste(pop(pict));
}

public void paste(int[] horiz){
if(state==1)          //substract old value from global pop counter
  earth.numFishes--;
if(state==2)
  earth.numSharks--;
state=(byte) horiz[0];//get your state
if(state==1)          //add new value to global pop counter
  earth.numFishes++;
if(state==2)
  earth.numSharks++;
initVals();
earth.grid[x][y]=state;
if(horiz.length>1&&right!=null)         //and send rest right
  right.paste(pop(horiz));
}

public static void setTime(timer time){
globaltime=time;
}

public static void setUniverse(universe univ){
earth=univ;
}

public void setleft(cell where){
left=where;
where.right=this;
}

public void setup(cell where){
up=where;
where.down=this;
}

public void setdown(cell where){
left=where;
}

public void setright(cell where){
left=where;
}

//public String givPos(){
//return "X: "+x+" Y: "+y;
//}

public cell(){ //(int x, int y){
//this.setEnabled(false);
//this.x=x;  //do we need this coordinates?
//this.y=y;
this.state=0;
this.newState=0;
initVals();
}

public cell(int posType){ //(int x, int y){
this.posType=posType;
//this.setEnabled(false);
//this.x=x;  //do we need this coordinates?
//this.y=y;
this.state=0;
this.newState=0;
}

public void changeState(){
state++;
if(state==maxstate)
  state=0;
earth.grid[x][y]=state;
}

public void switchs(){
changeState();
//repaint();
}

}
