/*
This is an implementation of Wator, an eco system resembling natural
predator-prey interaction; this Cellular Automaton delivers similar
results to those of the Lotka-Volterra equation.

I got the idea from and refer for further information to:
A.K. Dewdney 
Sharks and fish wage an ecological war on the toroidal planet Wa-Tor 
(Scientific American, December 1984) 

You may use and change this sourcecoude as you wish.
Johannes Knabe (knabe@panmental.de)
Trondheim, Norway, 05.10.2003 (10/05/03)
Source website: http://panmental.de
*/
import java.awt.*;
import java.awt.event.*;
import java.applet.Applet; 

public class wator extends Applet { 

public int initSize=40;
public int initBorderStyle=0;
public timer globaltime;

public wator(){
}

public String getAppletInfo()
{
return "A.K. Dewdney, Wa-Tor eco system (1984) - Author J.Knabe, jknabe@panmental.de - 10.2003 - Source available at http://www.panmental.de";
}


public void start(){
}

public void init() { 
globaltime=new timer();
universe earth=new universe(initSize,initBorderStyle,globaltime);
globaltime.earth=earth;
god pope =new god(earth,globaltime);
GridBagLayout gridbag = new GridBagLayout();

    GridBagConstraints c2 = new GridBagConstraints();
    c2.anchor=GridBagConstraints.CENTER;
    c2.fill=GridBagConstraints.BOTH;
    c2.ipadx=1;
    c2.weightx =1;
    c2.weighty =1;
    c2.gridheight =GridBagConstraints.REMAINDER;
    gridbag.setConstraints(earth, c2);

    GridBagConstraints c3 = new GridBagConstraints();
    c3.anchor=GridBagConstraints.NORTHEAST;
    c3.ipadx=0;
    gridbag.setConstraints(globaltime, c3);

    GridBagConstraints c1 = new GridBagConstraints();
    c1.anchor=GridBagConstraints.NORTHEAST;
    c1.ipadx=0;
    c1.gridwidth =GridBagConstraints.REMAINDER;
    gridbag.setConstraints(pope, c1);

setLayout(gridbag);
add(earth); 
add(globaltime);
add(pope); 
} 

public static void main(String[] argv){
System.out.print("loading...");
new AppletFrame("A.K. Dewdney, Wa-Tor eco system",new wator(),800,600);
System.out.println("enjoy!");
}

}

class AppletFrame extends Frame {

private wator display;

AppletFrame(String title, wator applet, int width, int height){
  super(title);
  display=applet;
  applet.init();
  applet.setVisible(true);
  this.add(applet);
  this.pack();
  this.setSize(width,height);
  this.show();
  addWindowListener(
      new WindowAdapter() {  // close the window when the user clicks its close box
          public void windowClosing(WindowEvent evt) {
          close();
          }
      });
}

public void close(){
   if(display.globaltime.actiontimer.isRunning())
      display.globaltime.actiontimer.stop();
   display.removeAll();
   dispose();
   try{
    finalize();}catch(java.lang.Throwable e){System.err.println("Error on shuting down: "+e);}
   System.out.println("bye");
   System.exit(0);
   }

}
